﻿<%
'--------------------------------------------
' 名称：CheckError()
' 作用：错误陷阱
'--------------------------------------------
Sub CheckError()
	If Err Then
		Err.Clear
		ShowMessage "博客程序出现未知错误，此次请求被取消", "Default.asp"
		Response.End
	End If
End Sub

'--------------------------------------------
' 名称：CheckLogin()
' 作用：判断是否登录
' 其他：包括 1 - 10 用户组
'--------------------------------------------
Function CheckLogin()
	If Session("UserGroup") > 0 Then
		CheckLogin = True
	Else
		CheckLogin = False
	End If
End Function

'--------------------------------------------
' 名称：CheckAdmin()
' 作用：判断是否有前台管理权限
' 其他：包括 8, 9, 10 用户组
'--------------------------------------------
Function CheckAdmin()
	If Session("UserGroup") > 7 Then
		CheckAdmin = True
	Else
		CheckAdmin = False
	End If
End Function

'--------------------------------------------
' 名称：CheckSuperAdmin()
' 作用：判断是否有后台管理权限
' 其他：包括 10 用户组
'--------------------------------------------
Function CheckSuperAdmin()
	If Session("UserGroup") > 9 Then
		CheckSuperAdmin = True
	Else
		CheckSuperAdmin = False
	End If
End Function

'--------------------------------------------
' 名称：DelStr(str)
' 作用：清除换行标记
'--------------------------------------------
Function DelStr(str)
	If Len(str) = 0 Then
		Exit Function
	End If
	str = Replace(str, "<br/>", "")
	str = Replace(str, "<br />", "")
	DelStr = str
End Function

'--------------------------------------------
' 名称：CheckSuperAdmin()
' 作用：日期转换输出
' 其他：改写自 PJBlog
'--------------------------------------------
Function DateToStr(DateTime, ShowType)
    Dim DateMonth, DateDay, DateHour, DateMinute, DateWeek, DateSecond
    Dim FullWeekday, shortWeekday, Fullmonth, Shortmonth, TimeZone1, TimeZone2
    TimeZone1 = "+0800"
    TimeZone2 = "+08:00"
    FullWeekday = Array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday")
    shortWeekday = Array("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat")
    Fullmonth = Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December")
    Shortmonth = Array("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec")

    DateMonth = Month(DateTime)
    DateDay = Day(DateTime)
    DateHour = Hour(DateTime)
    DateMinute = Minute(DateTime)
    DateWeek = Weekday(DateTime)
    DateSecond = Second(DateTime)
    If Len(DateMonth)<2 Then DateMonth = "0"&DateMonth
    If Len(DateDay)<2 Then DateDay = "0"&DateDay
    If Len(DateMinute)<2 Then DateMinute = "0"&DateMinute
    Select Case ShowType
        Case "Y-m-d"
            DateToStr = Year(DateTime)&"-"&DateMonth&"-"&DateDay
        Case "Y-m-d zh-cn"
            DateToStr = Year(DateTime)&"年"&DateMonth&"月"&DateDay&"日"
        Case "Y-m-d H:I A"
            Dim DateAMPM
            If DateHour>12 Then
                DateHour = DateHour -12
                DateAMPM = "PM"
            Else
                DateHour = DateHour
                DateAMPM = "AM"
            End If
            If Len(DateHour)<2 Then DateHour = "0"&DateHour
            DateToStr = Year(DateTime)&"-"&DateMonth&"-"&DateDay&" "&DateHour&":"&DateMinute&" "&DateAMPM
        Case "Y-m-d H:I:S"
            If Len(DateHour)<2 Then DateHour = "0"&DateHour
            If Len(DateSecond)<2 Then DateSecond = "0"&DateSecond
            DateToStr = Year(DateTime)&"-"&DateMonth&"-"&DateDay&" "&DateHour&":"&DateMinute&":"&DateSecond
		Case "Y-m-d H:I:S zh-cn"
			If Len(DateHour)<2 Then DateHour = "0"&DateHour
			If Len(DateSecond)<2 Then DateSecond = "0"&DateSecond
			DateToStr = Year(DateTime)&"年"&DateMonth&"月"&DateDay&"日"&DateHour&"时"&DateMinute&"分"&DateSecond&"秒"
        Case "YmdHIS"
            DateSecond = Second(DateTime)
            If Len(DateHour)<2 Then DateHour = "0"&DateHour
            If Len(DateSecond)<2 Then DateSecond = "0"&DateSecond
            DateToStr = Year(DateTime)&DateMonth&DateDay&DateHour&DateMinute&DateSecond
        Case "ym"
            DateToStr = Right(Year(DateTime), 2)&DateMonth
        Case "d"
            DateToStr = DateDay
        Case "ymd"
            DateToStr = Right(Year(DateTime), 4)&DateMonth&DateDay
        Case "mdy"
            Dim DayEnd
            Select Case DateDay
            Case 1
                DayEnd = "st"
            Case 2
                DayEnd = "nd"
            Case 3
                DayEnd = "rd"
            Case Else
                DayEnd = "th"
        End Select
        DateToStr = Fullmonth(DateMonth -1)&" "&DateDay&DayEnd&" "&Right(Year(DateTime), 4)
        Case "w,d m y H:I:S"
            DateSecond = Second(DateTime)
            If Len(DateHour)<2 Then DateHour = "0"&DateHour
            If Len(DateSecond)<2 Then DateSecond = "0"&DateSecond
            DateToStr = shortWeekday(DateWeek -1)&","&DateDay&" "& Left(Fullmonth(DateMonth -1), 3) &" "&Right(Year(DateTime), 4)&" "&DateHour&":"&DateMinute&":"&DateSecond&" "&TimeZone1
        Case "y-m-dTH:I:S"
            If Len(DateHour)<2 Then DateHour = "0"&DateHour
            If Len(DateSecond)<2 Then DateSecond = "0"&DateSecond
            DateToStr = Year(DateTime)&"-"&DateMonth&"-"&DateDay&"T"&DateHour&":"&DateMinute&":"&DateSecond&TimeZone2
        Case Else
            If Len(DateHour)<2 Then DateHour = "0"&DateHour
            DateToStr = Year(DateTime)&"-"&DateMonth&"-"&DateDay&" "&DateHour&":"&DateMinute
    End Select
End Function

'--------------------------------------------
' 名称：Temp_Load( ByVal TemplateName )
' 作用：载入指定模板
'--------------------------------------------
Function Temp_Load( ByVal TemplateName )
	Dim FilePath,Fso
	Set Fso = Server.CreateObject("Scripting.FileSystemObject")
	If Fso.FileExists( Server.MapPath( BlogPath & "Style/" & BlogStyle & "/Template/" & TemplateName ) ) Then
		FilePath = BlogPath & "Style/" & BlogStyle & "/Template/" & TemplateName
		Temp_Load = LoadFile( FilePath )
	ElseIf Fso.FileExists( Server.MapPath( BlogPath & "Template/" & TemplateName ) ) Then
		FilePath = BlogPath & "Template/" & TemplateName
		Temp_Load = LoadFile( FilePath )
	Else
		Temp_Load = ""
	End If
	Set Fso = Nothing
End Function

'--------------------------------------------
' 名称：Temp_Save( ByVal TemplateName, ByRef Template )
' 作用：载入指定模板
'--------------------------------------------
Function Temp_Save( ByVal TemplateName, ByRef Template )
	Dim FilePath,Fso
	Set Fso = Server.CreateObject("Scripting.FileSystemObject")
	If Fso.FileExists( Server.MapPath( BlogPath & "Style/" & BlogStyle & "/Template/" & TemplateName ) ) Then
		FilePath = BlogPath & "Style/" & BlogStyle & "/Template/" & TemplateName
	ElseIf Fso.FileExists( Server.MapPath( BlogPath & "Template/" & TemplateName ) ) Then
		FilePath = BlogPath & "Template/" & TemplateName
	Else
		FilePath = ""
	End If
	Set Fso = Nothing
	If FilePath = "" Then
		Temp_Save = False
	Else
		SaveFile Template,FilePath
		Temp_Save = True
	End If
End Function

'--------------------------------------------
' 名称：LoadFile(FilePath)
' 作用：读取文件
'--------------------------------------------
Function LoadFile(FilePath)
	Dim Stream
	Set Stream = Server.CreateObject("ADODB.Stream")
	With Stream
		.Type = 2
		.Open
		.Charset = "UTF-8"
		.Position = Stream.Size
       	.LoadFromFile Server.MapPath(FilePath)
		LoadFile = .ReadText
		.Close
	End With
	Set Stream = Nothing
End Function

'--------------------------------------------
' 名称：SaveFile(File,FilePath)
' 作用：保存文件
'--------------------------------------------
Sub SaveFile(File,FilePath)
	Dim Stream
	Set Stream = Server.CreateObject("ADODB.Stream")
    With Stream
    .Open
    .Charset = "UTF-8"
    .Position = Stream.Size
    .WriteText = File
    .SaveToFile Server.MapPath(FilePath), 2
    .Close
    End With
	Set Stream = Nothing
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Function GetKey(digits)

	dim char_array(36)
	dim output, num
	char_array(0)   =   "0"
	char_array(1)   =   "1"
	char_array(2)   =   "2"
	char_array(3)   =   "3"
	char_array(4)   =   "4"
	char_array(5)   =   "5"
	char_array(6)   =   "6"
	char_array(7)   =   "7"
	char_array(8)   =   "8"
	char_array(9)   =   "9"
	char_array(10)  =   "a"
	char_array(11)  =   "s"
	char_array(12)  =   "d"
	char_array(13)  =   "f"
	char_array(14)  =   "e"
	char_array(15)  =   "f"
	char_array(16)  =   "g"
	char_array(17)  =   "h"
	char_array(18)  =   "i"
	char_array(19)  =   "j"
	char_array(20)  =   "k"
	char_array(21)  =   "l"
	char_array(22)  =   "m"
	char_array(23)  =   "n"
	char_array(24)  =   "o"
	char_array(25)  =   "p"
	char_array(26)  =   "q"
	char_array(27)  =   "r"
	char_array(28)  =   "s"
	char_array(29)  =   "t"
	char_array(30)  =   "u"
	char_array(31)  =   "v"
	char_array(32)  =   "w"
	char_array(33)  =   "x"
	char_array(34)  =   "y"
	char_array(35)  =   "z"

	Randomize

	Do While len(output) < digits
		num = char_array(Int((35)*Rnd+0))
		output =output+num
	Loop

	GetKey = output
End Function

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Function CheckObjInstalled( strClassString )
	On Error Resume Next
	Dim TmpObj
	Set TmpObj = Server.CreateObject( strClassString )
	If Err Then
		Err.Clear
		CheckObjInstalled = False
	Else
		Set TmpObj = Nothing
		CheckObjInstalled = True
	End If
End Function

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Function vbsEscape(str) 
    dim i,s,c,a 
    s="" 
    For i=1 to Len(str) 
        c=Mid(str,i,1) 
        a=ASCW(c) 
        If (a>=48 and a<=57) or (a>=65 and a<=90) or (a>=97 and a<=122) Then 
            s = s & c 
        ElseIf InStr("@*_+-./",c)>0 Then 
            s = s & c 
        ElseIf a>0 and a<16 Then 
            s = s & "%0" & Hex(a) 
        ElseIf a>=16 and a<256 Then 
            s = s & "%" & Hex(a) 
        Else 
            s = s & "%u" & Hex(a) 
        End If 
    Next 
    vbsEscape = s 
End Function

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Function vbsUnEscape(str)
    dim i,s,c 
    s="" 
    For i=1 to Len(str) 
        c=Mid(str,i,1) 
        If Mid(str,i,2)="%u" and i<=Len(str)-5 Then 
            If IsNumeric("&H" & Mid(str,i+2,4)) Then 
                s = s & CHRW(CInt("&H" & Mid(str,i+2,4))) 
                i = i+5 
            Else 
                s = s & c 
            End If 
        ElseIf c="%" and i<=Len(str)-2 Then 
            If IsNumeric("&H" & Mid(str,i+1,2)) Then 
                s = s & CHRW(CInt("&H" & Mid(str,i+1,2))) 
                i = i+2 
            Else 
                s = s & c 
            End If 
        Else 
            s = s & c 
        End If 
    Next 
    vbsUnEscape = s 
End Function 

'=====================================================================================
' Document :  EasyIDE ASP Framework [EasyIDE ASP 开发框架]
' Version  :  2008纪念版
' Author   :  WangJun(無意メ沉淪↓)
' Contact  :  www.EasyIDE.cn  mx_whu@qq.com
' Update   :  2008-12-14 AM
' Comments :  作者WangJun [EasyIDE.cn]保留程序的所有权。你可以自由使用本程序，但请保留此段注释。
'             如果你对EasyIDE Framework进行了修正或增强，请发送一份到作者邮箱，非常感谢你的支持。
'             本文件为UTF-8版本，使用方面的问题请查阅附属的API文档[ EasyIDE.API.htm ]。
'=====================================================================================

'/////////字符串操作函数部分

'函数：正则验证
function str_test(pattern,str)
	dim tmp : tmp = false
	dim reg : set reg = new regexp
	with reg
		.ignorecase = true
		.global = true
		.pattern = pattern
		tmp = .test(str)
	end with
	set reg = nothing
	str_test = tmp
end function

'函数：正则替换
function str_replace(pattern,str,s)
	dim tmp : tmp = false
	dim reg : set reg = new regexp
	with reg
		.ignorecase = true
		.global = true
		.pattern = pattern
		tmp = .replace(str,s)
	end with
	set reg = nothing
	str_replace = tmp
end function

'函数：正则替换[区分大小写]
function str_ireplace(pattern,str,s)
	dim tmp : tmp = false
	dim reg : set reg = new regexp
	with reg
		.ignorecase = false
		.global = true
		.pattern = pattern
		tmp = .replace(str,s)
	end with
	set reg = nothing
	str_ireplace = tmp
end function

'函数：执行正则搜索并返回结果集
function str_execute(pattern,str)
	dim tmp : tmp = false
	dim reg : set reg = new regexp
	with reg
		.ignorecase = true
		.global = true
		.pattern = pattern
		set tmp = .execute(str)
	end with
	set reg = nothing
	set str_execute = tmp
end function

'函数：执行正则搜索并返回结果集
function str_iexecute(pattern,str)
	dim tmp : tmp = false
	dim reg : set reg = new regexp
	with reg
		.ignorecase = false
		.global = true
		.pattern = pattern
		set tmp = .execute(str)
	end with
	set reg = nothing
	set str_iexecute = tmp
end function

'函数：精确计算字符串长度
function Str_Count( byval str )
	str = str_replace("[^\x00-\xff]",str,"@@")
	str_count = len(str)
end function

'函数：截断字串[按字符数]
function Str_Cut(byval str,slen,ext)
	if isnull(str) then str = ""
	dim tmp : tmp = "&quot;=""|&amp;=&|&lt;=<|&gt;=>|&euro;=€|&nbsp;= |&laquo;=«|&raquo;=»|&hellip;=…|&copy;=©"
	dim arr, a, v : arr = split(tmp,"|")
	for each v in arr
		a = split(v,"=")
		str = replace(str,a(0),a(1))
	next
	'die str
	dim i, c, s, n : n = 0 : tmp = ""
	for i=1 to len(str)
		s = mid(str,i,1)
		c = abs(ascw(s))
		if c>255 then n=n+2 else n=n+1
		tmp = tmp & s
		if n >= slen then exit for
	next
	if tmp=str then ext=""
	str_cut = tmp & ext
end function

'函数：截断字串[按行]
Function Str_ICut( byval str,slen,num,ext )
	dim pattern : pattern = "<[ ]*?br[ /]*?>"
	str = str_replace(pattern,str,"<br />")
	pattern = "<[ ]*?/p[ ]*?>"
	str = str_replace(pattern,str,"</p>")
	dim tmp : tmp = "&quot;=""|&amp;=&|&lt;=<|&gt;=>|&euro;=€|&nbsp;= |&laquo;=«|&raquo;=»|&hellip;=…|&copy;=©"
	dim arr, a, v : arr = split(tmp,"|")
	for each v in arr
		a = split(v,"=")
		str = replace(str,a(0),a(1))
	next
	dim i, s, c, l, sline : l=0 : sline=0 : tmp=""
	for i = 1 to len(str)
		s = mid(str,i,6)
		if s = "<br />" then
			sline = sline + 1
			l = 0
			i = i + 5
		elseif left(s,4) = "</p>" then
			sline = sline + 1
			l = 0
			i = i + 3
		else
			s = mid(str,i,1)
			c = abs(ascw(s))
			if c>255 then l = l+2 else l = l+1
		end if
		if l/slen>=1 then sline = sline+1 : l = 0
		tmp = tmp & s
		if sline >= num then exit for
	next
	if tmp=str then ext=""
	str_icut = tmp & ext
End Function

'函数：SQL关键词过滤
function str_desqlin(byval str)
	str = replace(str,"select ","sel&#101;ct",1,-1,1)
	str = replace(str,"insert ","ins&#101;rt",1,-1,1)
	str = replace(str,"update ","up&#100;ate",1,-1,1)
	str = replace(str,"delete ","del&#101;te",1,-1,1)
	str = replace(str," and"," an&#100;",1,-1,1)
	str = replace(str,"drop table","dro&#112; table",1,-1,1)
	str = replace(str,"<","&lt;")
	str = replace(str,">","&gt;")
	str = replace(str,"*","&#42;")
	str = replace(str,"%","&#37;")
	str = replace(str,"'","''")
	str_desqlin = str
end function

'函数：HTML标签过滤
function str_htmldecode(byval str)
	str = replace(str,"&nbsp;"," ")
	str = replace(str,"<br />",chr(10))
	str_htmldecode = str
end function

'函数：控制字符格式化为HTML
function str_htmlencode(byval str)
	str = replace(str," ","&nbsp;")
	str = replace(str,chr(10),"<br />")
	'str = replace(str,chr(13),"<br />")
	str_htmlencode = str
end function

'函数：清除html标签
function str_htmlclear(byval str)
	str = replace(str,"&nbsp;"," ")
	dim pattern : pattern = "<[^>]+?>"
	str = str_replace(pattern,str,"")
	str_htmlclear = str
end function

'函数：返回随机字串
function str_rnd()
	dim ran_num, dt_now, tmp : dt_now = now()
	randomize : ran_num = int( (90000*rnd) + 10000 )
	tmp = year(dt_now) & right("0"&month(dt_now),2) & right("0"&day(dt_now),2) & right("0"&hour(dt_now),2) &_
	      right("0"&minute(dt_now),2) & right("0"&second(dt_now),2) & ran_num
	str_rnd = base64encode(tmp)
end function

'函数：字符串中的数字转换为汉字
function str_number(str,model)
	dim arr, i, s, tmp : tmp = ""
	if model = 1 then
		arr = array("零","一","二","三","四","五","六","七","八","九")
	elseif model = 2 then
		arr = array("零","壹","贰","叁","肆","伍","陆","柒","捌","玖")
	end if
	for i=1 to len(str)
		s = mid(str,i,1)
		if isnumeric(s) then tmp = tmp & arr(s) else tmp = tmp & s
	next 
	str_number = tmp
end function
%>